<?php
// index.php - Main entry point / Router

session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id']) && basename($_SERVER['PHP_SELF']) !== 'login.php' && basename($_SERVER['PHP_SELF']) !== 'callback.php') {
    header('Location: login.php');
    exit;
}

// Include configuration
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/src/Database.php';
require_once __DIR__ . '/src/OAuth.php';
require_once __DIR__ . '/src/AdMobAPI.php';
require_once __DIR__ . '/src/ReportGenerator.php';

// Get the requested page
$page = isset($_GET['page']) ? sanitize_input($_GET['page']) : 'dashboard';

// Define available pages
$available_pages = ['dashboard', 'reports', 'apps', 'ad-units', 'account', 'settings'];

// Validate page
if (!in_array($page, $available_pages)) {
    $page = 'dashboard';
}

// Load the appropriate page
$page_file = __DIR__ . '/pages/' . $page . '.php';

if (file_exists($page_file)) {
    include $page_file;
} else {
    include __DIR__ . '/pages/dashboard.php';
}

// Helper functions
function sanitize_input($input) {
    return htmlspecialchars(strip_tags(trim($input)));
}

function get_user_data() {
    if (isset($_SESSION['user_data'])) {
        return json_decode($_SESSION['user_data'], true);
    }
    return null;
}

?>