<?php
// includes/header.php
?>
<header class="top-header">
    <div class="header-left">
        <button class="menu-toggle" onclick="toggleSidebar()">
            <i class="fas fa-bars"></i>
        </button>
        <h1 class="page-title"><?php echo $page_title ?? 'Dashboard'; ?></h1>
    </div>
    
    <div class="header-right">
        <div class="header-stats">
            <div class="stat-item">
                <i class="fas fa-dollar-sign"></i>
                <span id="header-earnings">$0.00</span>
            </div>
            <div class="stat-item">
                <i class="fas fa-eye"></i>
                <span id="header-impressions">0</span>
            </div>
        </div>
        
        <div class="user-menu">
            <button class="user-button" onclick="toggleUserMenu()">
                <?php if (isset($_SESSION['user_picture']) && !empty($_SESSION['user_picture'])): ?>
                    <img src="<?php echo htmlspecialchars($_SESSION['user_picture']); ?>" alt="User" class="user-avatar">
                <?php else: ?>
                    <i class="fas fa-user-circle"></i>
                <?php endif; ?>
                <span><?php echo htmlspecialchars($_SESSION['user_name'] ?? $_SESSION['user_email'] ?? 'User'); ?></span>
                <i class="fas fa-chevron-down"></i>
            </button>
            
            <div class="user-dropdown" id="user-dropdown">
                <div class="dropdown-header">
                    <strong><?php echo htmlspecialchars($_SESSION['user_name'] ?? 'User'); ?></strong>
                    <small><?php echo htmlspecialchars($_SESSION['user_email'] ?? ''); ?></small>
                </div>
                <div class="dropdown-divider"></div>
                <a href="/admob-manager/pages/settings.php" class="dropdown-item">
                    <i class="fas fa-cog"></i> Settings
                </a>
                <a href="/admob-manager/logout.php" class="dropdown-item">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
    </div>
</header>

<script>
function toggleSidebar() {
    document.querySelector('.sidebar').classList.toggle('collapsed');
    document.querySelector('.main-content').classList.toggle('expanded');
}

function toggleUserMenu() {
    const dropdown = document.getElementById('user-dropdown');
    dropdown.classList.toggle('show');
}

// Close dropdown when clicking outside
window.addEventListener('click', function(e) {
    if (!e.target.matches('.user-button') && !e.target.closest('.user-button')) {
        const dropdown = document.getElementById('user-dropdown');
        if (dropdown && dropdown.classList.contains('show')) {
            dropdown.classList.remove('show');
        }
    }
});

// Load header stats
async function loadHeaderStats() {
    try {
        const response = await fetch('/admob-manager/api/dashboard.php?action=summary');
        const data = await response.json();
        
        if (data.success) {
            document.getElementById('header-earnings').textContent = 
                '$' + (data.data.today_earnings || 0).toFixed(2);
            document.getElementById('header-impressions').textContent = 
                new Intl.NumberFormat().format(data.data.today_impressions || 0);
        }
    } catch (error) {
        console.error('Failed to load header stats:', error);
    }
}

// Load stats on page load
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', loadHeaderStats);
} else {
    loadHeaderStats();
}

// Refresh stats every 5 minutes
setInterval(loadHeaderStats, 300000);
</script>