<?php
// login.php - Google OAuth Login Handler

session_start();

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/src/OAuth.php';

// Initialize OAuth
$oauth = new OAuth(GOOGLE_CLIENT_ID, GOOGLE_CLIENT_SECRET, GOOGLE_REDIRECT_URI);

// Check if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

// Get login URL
$login_url = $oauth->getLoginUrl();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AdMob Manager - Login</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            padding: 40px;
            max-width: 420px;
            width: 90%;
            text-align: center;
        }

        .logo {
            font-size: 48px;
            margin-bottom: 20px;
        }

        h1 {
            color: #202124;
            font-size: 28px;
            margin-bottom: 10px;
        }

        .subtitle {
            color: #5f6368;
            font-size: 14px;
            margin-bottom: 30px;
        }

        .login-button {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            width: 100%;
            padding: 12px 20px;
            background: #1a73e8;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            margin-bottom: 20px;
        }

        .login-button:hover {
            background: #185abc;
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(26, 115, 232, 0.3);
        }

        .google-icon {
            font-size: 20px;
        }

        .divider {
            display: flex;
            align-items: center;
            gap: 12px;
            margin: 30px 0;
            color: #5f6368;
            font-size: 14px;
        }

        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: #dadce0;
        }

        .info-text {
            color: #5f6368;
            font-size: 13px;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        .features {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin-top: 20px;
            text-align: left;
        }

        .features h3 {
            color: #202124;
            font-size: 14px;
            margin-bottom: 12px;
        }

        .features ul {
            list-style: none;
            font-size: 13px;
            color: #5f6368;
        }

        .features li {
            padding: 6px 0;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .features li::before {
            content: '✓';
            color: #34a853;
            font-weight: bold;
        }

        .error {
            background: #fcf0f5;
            border: 1px solid #f28b82;
            color: #c5221f;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-size: 14px;
        }

        @media (max-width: 600px) {
            .login-container {
                padding: 30px 20px;
            }

            h1 {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">📊</div>
        <h1>AdMob Manager</h1>
        <p class="subtitle">Manage all your AdMob accounts in one place</p>

        <?php if (isset($_GET['error'])): ?>
            <div class="error">
                ⚠️ <?php echo htmlspecialchars($_GET['error']); ?>
            </div>
        <?php endif; ?>

        <a href="<?php echo htmlspecialchars($login_url); ?>" class="login-button">
            <span class="google-icon">🔐</span>
            <span>Sign in with Google</span>
        </a>

        <div class="divider">OR</div>

        <p class="info-text">
            Sign in with your Google account to get instant access to all your AdMob data, generate reports, manage ad units, and optimize your earnings.
        </p>

        <div class="features">
            <h3>What you can do:</h3>
            <ul>
                <li>Access real-time earnings & performance</li>
                <li>Generate custom reports</li>
                <li>Manage apps & ad units</li>
                <li>Monitor multiple accounts</li>
                <li>Export data to CSV</li>
                <li>View detailed analytics</li>
            </ul>
        </div>

        <div class="info-text" style="margin-top: 20px; font-size: 12px; color: #9aa0a6;">
            By signing in, you agree to share your AdMob account data with this application. We only read your data and never modify it.
        </div>
    </div>
</body>
</html>
